<?php

namespace Bongo\Framework\Schema\Concerns;

use Bongo\Page\Models\Page;
use Bongo\Post\Models\Post;
use Bongo\Post\Models\PostCategory;
use Bongo\Project\Models\Project;
use Bongo\Project\Models\ProjectCategory;
use Illuminate\Database\Eloquent\Model;

trait HandlesEntity
{
    protected Model $entity;

    public function setEntity(Model $entity): self
    {
        $this->entity = $entity;

        return $this;
    }

    public function getUrlForEntity(Model $entity): ?string
    {
        if ($entity instanceof Page) {
            return route('frontend.page.show', $entity->slug);
        }
        if ($entity instanceof Post) {
            return route('frontend.post.show', $entity->slug);
        }
        if ($entity instanceof PostCategory) {
            return route('frontend.post_category.show', $entity->slug);
        }
        if ($entity instanceof Project) {
            return route('frontend.project.show', $entity->slug);
        }
        if ($entity instanceof ProjectCategory) {
            return route('frontend.project_category.show', $entity->slug);
        }

        return null;
    }
}
