<?php

namespace Bongo\Framework\Schema\Concerns;

use Spatie\SchemaOrg\Graph;
use Spatie\SchemaOrg\LocalBusiness;
use Spatie\SchemaOrg\ReferencedType;

trait HandlesWebSite
{
    public function addWebSite(): self
    {
        $this->webSite($this->webSiteId)
            ->identifier($this->webSiteId)
            ->url($this->getWebSiteUrl())
            ->name($this->getWebSiteName())
            ->about($this->getWebSiteAbout())
            ->inLanguage($this->getWebSiteLanguage());

        return $this;
    }

    protected function getWebSiteUrl(): ?string
    {
        return config('schema.site_url') ?? url()->to('/');
    }

    protected function getWebSiteName(): ?string
    {
        return config('schema.site_name') ?? config('app.name');
    }

    protected function getWebSiteAbout(): LocalBusiness|ReferencedType|Graph
    {
        return $this->localBusiness($this->localBusinessId)->referenced();
    }

    protected function getWebSiteLanguage(): string
    {
        return app()->getLocale() ?? 'en-GB';
    }
}
