<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Audit;

use Bongo\User\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;

trait HasUpdatedBy
{
    public function initializeHasUpdatedBy(): void
    {
        $this->mergeFillable(['updated_by']);
    }

    public static function bootHasUpdatedBy(): void
    {
        static::updating(function ($model) {
            if (Schema::hasColumn($model->getTable(), 'updated_by')) {
                $model->updated_by = Auth::user() ? Auth::user()->id : null;
            }
        });
    }

    public function updater(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by')->withTrashed();
    }

    public function scopeByUpdater(Builder $query, ?int $userId = null): Builder
    {
        return $query->where('updated_by', $userId ?? Auth::user()->id);
    }
}
