<?php

namespace Bongo\Framework\Traits;

use Bongo\Framework\Helpers\Html;
use Illuminate\Support\Str;

trait HasContent
{
    public function getSummaryAttribute(): ?string
    {
        return $this->getSummary();
    }

    public function getSummary(int $limit = 50): ?string
    {
        return Str::limit(trim(preg_replace('/\s\s+/', ' ', strip_tags($this->content))), $limit);
    }

    public function getContentCleanAttribute(): ?string
    {
        return $this->getContentClean();
    }

    public function getContentClean(): ?string
    {
        $content = preg_replace('/(data-noedit|data-module|data-dialog|data-dialog-width|data-settings|data-module-desc|data-html)="[^"]*"/',
            '', $this->content);

        for ($i = 0; $i < 50; $i++) {
            $content = preg_replace('/(data-html-'.$i.')="[^"]*"/', '', $content);
        }

        // Remove line breaks and multiple spaces
        $content = str_replace("\r", '', $content);
        $content = str_replace("\n", '', $content);

        return trim(preg_replace('/\s\s+/', ' ', $content));
    }

    public function getContentPlainAttribute(): ?string
    {
        return $this->getContentAsPlainText();
    }

    public function getContentAsPlainText($except = null): ?string
    {
        if (empty($this->content_clean)) {
            return null;
        }

        // Remove tags, line breaks, non-breaking spaces and multiple spaces
        $content = Html::removeJavascript($this->content_clean);
        $content = str_replace(">", '> ', $content);
        $content = strip_tags(nl2br($content), $except);
        $content = str_replace("&nbsp;", ' ', $content);
        $content = Html::removeStyles($content);
        $content = Html::removeClasses($content);
        $content = Html::removeDataAttributes($content);
        $content = Html::removeEmptyTags($content);
        $content = Html::parse($content);

        // Remove any new surrounding spaces
        return trim(preg_replace('/\s\s+/', ' ', $content));
    }
}
