<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

    <head>
        @php
            $version   = setting('system::misc.version');
            $metaTitle = preg_replace("/\?.*$/", '', request()->path());
            $metaTitle = ucwords(str_replace(['_', '-', '/'], ' ', $metaTitle));
            $pageClass = request()->segment(1) ? str(request()->segment(1))->singular() . '-page' : '';
        @endphp

        <title>@yield('meta_title', $metaTitle)</title>
        @include('framework::backend.layouts.partials.meta_standard')
        @include('framework::backend.layouts.partials.favicon')

        @section('header_css')
            <link rel="stylesheet" href="https://rsms.me/inter/inter.css">
            <link rel="stylesheet" type="text/css" href="{{ asset("css/backend.css?{$version}") }}"/>
        @show
    </head>

    <body class="relative antialiased font-sans bg-gray-200 text-gray-900 @yield('body_class', $pageClass)">

        <div class="min-h-screen flex flex-col justify-center py-12 sm:px-6 lg:px-8">

            <div class="sm:mx-auto sm:w-full sm:max-w-md">

                <a class="block"
                   href="/"
                   title="This link will return you to the home page"
                   aria-label="This link will return you to the home page"
                >
                    <img class="mx-auto h-20 w-auto"
                         alt="{{ setting("client::company.name") }}"
                         src="{{ setting("theme::logo.default") }}"
                    >
                </a>

                <h2 class="mt-6 text-center text-2xl leading-9 font-semibold uppercase text-gray-800">
                    @yield('heading')
                </h2>

                @yield('sub_heading')
            </div>

            <div class="mt-8 sm:mx-auto sm:w-full sm:max-w-md">
                @component('blade::card', ['class' => 'py-8 px-4 sm:px-10'])
                    @yield('content')
                @endcomponent
            </div>
        </div>

        @include('blade::message')
    </body>
</html>
