<template slot="header-menu-avatar">
    <div class="flex items-end h-8 w-8 rounded-full border-2 border-gray-200 bg-gray-100 hover:bg-gray-200"
         v-tooltip='"Click here to open <br />the <b>Sub Menu</b>"'
    >
        <img class="rounded-full"
             src="{{ asset(user()->getAvatar()) }}"
             alt="{{ user()->name }}"
        />
    </div>
</template>

<div class="py-1">
    <a href="{{ route('backend.profile.index') }}"
       class="group flex items-center px-4 py-2 text-sm leading-5 text-gray-700 hover:bg-gray-100 hover:text-gray-900 focus:outline-none focus:bg-gray-100 focus:text-gray-900"
       title="Click here to view your profile"
    >
        <svg class="mr-3 h-5 w-5 text-gray-400 group-hover:text-gray-500 group-focus:text-gray-500"
             fill="currentColor" viewBox="0 0 20 20"
        >
            <path
                d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-6-3a2 2 0 11-4 0 2 2 0 014 0zm-2 4a5 5 0 00-4.546 2.916A5.986 5.986 0 0010 16a5.986 5.986 0 004.546-2.084A5 5 0 0010 11z"
                clip-rule="evenodd" fill-rule="evenodd"
            ></path>
        </svg>
        My Profile
    </a>
</div>

<div class="border-t border-gray-100"></div>
@if (session()->has('impersonating'))
    <div class="py-1">
        <a href="{{ route('backend.user.stop_impersonating') }}"
           class="group flex items-center px-4 py-2 text-sm leading-5 text-gray-700 hover:bg-gray-100 hover:text-gray-900 focus:outline-none focus:bg-gray-100 focus:text-gray-900"
           title="Click here to stop impersonating"
        >
            <svg class="mr-3 h-5 w-5 text-gray-400 group-hover:text-gray-500 group-focus:text-gray-500"
                 fill="currentColor" viewBox="0 0 20 20"
            >
                <path
                    d="M10 2a5 5 0 00-5 5v2a2 2 0 00-2 2v5a2 2 0 002 2h10a2 2 0 002-2v-5a2 2 0 00-2-2H7V7a3 3 0 015.905-.75 1 1 0 001.937-.5A5.002 5.002 0 0010 2z"
                ></path>
            </svg>
            Stop Impersonating
        </a>
    </div>
@else
    <div class="py-1">
        <a href="{{ url('/logout') }}"
           class="group flex items-center px-4 py-2 text-sm leading-5 text-gray-700 hover:bg-gray-100 hover:text-gray-900 focus:outline-none focus:bg-gray-100 focus:text-gray-900"
           title="Click here to securely sign out"
           onclick="event.preventDefault();document.getElementById('logout-form').submit();"
        >
            <svg class="mr-3 h-5 w-5 text-gray-400 group-hover:text-gray-500 group-focus:text-gray-500"
                 fill="currentColor" viewBox="0 0 20 20"
            >
                <path
                    d="M3 3a1 1 0 011 1v12a1 1 0 11-2 0V4a1 1 0 011-1zm7.707 3.293a1 1 0 010 1.414L9.414 9H17a1 1 0 110 2H9.414l1.293 1.293a1 1 0 01-1.414 1.414l-3-3a1 1 0 010-1.414l3-3a1 1 0 011.414 0z"
                    clip-rule="evenodd" fill-rule="evenodd"
                ></path>
            </svg>
            Sign Out
        </a>
    </div>
    <form id="logout-form" action="{{ url('/logout') }}"
          method="POST"
          style="display: none;"
    >
        {{ csrf_field() }}
    </form>
@endif
