<div id="cookie-manager">
    <div class="popup">
        <div class="popup-header">
            <img class="logo"
                 alt="{{ setting("client::company.name") }}"
                 src="{{ setting("theme::logo.default") }}"
            >
        </div>
        <div class="popup-content">
            <h2>Manage Cookies</h2>
            <p>
                Some cookies are needed to make our website work and can't be turned off. But we need your consent to
                use others that are not essential. You can make your choices below and update them at any time from
                the 'Cookies' link at the end of any page.
            </p>

            <section class="necessary">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <strong>NECESSARY</strong>
                    </div>
                    <div class="col-md-7">
                        These cookies are needed to run our website, to keep it
                        secure, and to obey regulations that apply to us.
                    </div>
                    <div class="col-md-2 mt-3 mt-md-0">
                        <button class="btn btn-sm btn-success disabled" type="button" value="necessary" disabled>
                            Always On
                        </button>
                    </div>
                </div>
            </section>

            <section class="functional">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <strong>FUNCTIONAL</strong>
                    </div>
                    <div class="col-md-7">
                        These cookies remember your region or country, language,
                        accessibility options and your settings. This also includes things like your User ID on the
                        logon page.
                    </div>
                    <div class="col-md-2 mt-3 mt-md-0">
                        <button class="btn btn-sm btn-success disabled" type="button" value="functional" disabled>
                            Always On
                        </button>
                    </div>
                </div>
            </section>

            <section class="statistics">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <strong>STATISTICS</strong>
                    </div>
                    <div class="col-md-7">
                        These cookies tell us how customers use our website. We study
                        and profile this data to help us improve our products and performance.
                    </div>
                    <div class="col-md-2 mt-3 mt-md-0">
                        <button id="btn-statistics"
                                class="btn btn-sm {{ cookie_enabled('bcc_statistics') ? 'btn-success' : 'btn-dark' }}"
                                type="button"
                                value="statistics"
                        >
                            {{ cookie_enabled('bcc_statistics') ? 'On' : 'Off' }}
                        </button>
                    </div>
                </div>
            </section>

            <section class="marketing">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <strong>MARKETING</strong>
                    </div>
                    <div class="col-md-7">
                        These cookies help us decide which products, services and
                        offers may be relevant for you. We may use this data to tailor the ads you see on our own and
                        other websites.
                    </div>
                    <div class="col-md-2 mt-3 mt-md-0">
                        <button id="btn-marketing"
                                class="btn btn-sm {{ cookie_enabled('bcc_marketing') ? 'btn-success' : 'btn-dark' }}"
                                type="button"
                                value="marketing"
                        >
                            {{ cookie_enabled('bcc_marketing') ? 'On' : 'Off' }}
                        </button>
                    </div>
                </div>
            </section>

            <section class="communication">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <strong>COMMUNICATION</strong>
                    </div>
                    <div class="col-md-7">
                        These cookies help us to communicate with you through live chat
                        widgets.
                    </div>
                    <div class="col-md-2 mt-3 mt-md-0">
                        <button id="btn-communication"
                                class="btn btn-sm {{ cookie_enabled('bcc_communication') ? 'btn-success' : 'btn-dark' }}"
                                type="button"
                                value="communication"
                        >
                            {{ cookie_enabled('bcc_communication') ? 'On' : 'Off' }}
                        </button>
                    </div>
                </div>
            </section>
        </div>

        <div class="popup-footer">
            <button id="back-to-consent" class="btn btn-light" type="button">
                Back To Consent
            </button>
            <button id="accept-cookies" class="btn btn-primary" type="button">
                Accept Selected
            </button>
        </div>
    </div>
</div>
