<?php

namespace Bongo\Framework\Helpers;

use Illuminate\Support\Str;

class File
{
    public static function generateName(string $name, string $ext): string
    {
        return strtolower(Str::slug(self::name($name)) . self::suffix() . '.' . $ext);
    }

    public static function suffix(): string
    {
        return config('image.suffix') . strtolower(Str::random(4));
    }

    public static function name(string $name): string
    {
        return strtolower(rtrim(ltrim($name, '/'), '/'));
    }

    public static function nameWithoutExtension(string $name): string
    {
        $extensions = ['.jpg', '.jpeg', '.png', '.bmp', '.gif', '.svg', '.webp'];

        return str_replace($extensions, '', self::name($name));
    }

    public static function nameWithoutSuffix(string $name): string
    {
        $name = self::nameWithoutExtension($name);

        if (Str::contains($name, config('image.suffix'))) {
            return substr($name, 0, strpos($name, config('image.suffix')));
        }

        return $name;
    }
}
