<?php

namespace Bongo\Framework\Helpers;

use Illuminate\Contracts\Container\BindingResolutionException;

/**
 * Class ShortCode
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2022 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   App\Framework\Helpers
 */
class ShortCode
{
    /**
     * @param $content
     *
     * @return string
     * @throws BindingResolutionException
     */
    public static function parse($content): string
    {
        // Replace the phone number
        $companyPhone = setting()->getClientPhoneNumber() ?? '#';
        $content = str_replace('[company_phone]', $companyPhone, $content);

        // Replace the email
        $companyEmail = setting('client::company.email', '#');
        $content = str_replace('[company_email]', $companyEmail, $content);

        // Return the parsed content
        return $content;
    }
}
