<?php

namespace Bongo\Framework\Helpers;

use Illuminate\Support\Facades\URL as URLFacade;
use Illuminate\Support\Str;

/**
 * Class Url
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2022 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   App\Framework\Helpers
 */
class URL
{
    public static function getBaseUrl(): string
    {
        return URLFacade::to('/');
    }

    public static function getHost(string $url): string
    {
        $parts = parse_url($url);

        if ($parts === false || ! isset($parts['host'])) {
            return '';
        }

        return $parts['host'];
    }

    public static function isHomePage($request): bool
    {
        return $request->is('') || $request->is('/');
    }

    public static function isAdmin($request): bool
    {
        return $request->is(config('settings.backend_prefix') . '*');
    }

    public static function isLogin($request): bool
    {
        return $request->is('login');
    }

    public static function isLogout($request): bool
    {
        return $request->is('logout');
    }

    public static function isAFile($request): bool
    {
        return ! empty(pathinfo($request->getPathInfo(), PATHINFO_EXTENSION));
    }

    public static function hasWWW($request): bool
    {
        return substr($request->header('host'), 0, 4) == 'www.';
    }

    public static function withoutWWW($request): string
    {
        return str_replace('www.', '', $request->header('host'));
    }

    public static function hasQueryString($request): bool
    {
        return !empty($request->getQueryString());
    }

    public static function endsWithSlash($request): bool
    {
        return Str::endsWith($request->getPathInfo(), '/');
    }
}
