<?php

namespace Bongo\Framework\Http\ViewComposers;

use Illuminate\Support\Facades\Request;
use Illuminate\View\View;

/**
 * Class BreadcrumbComposer.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Http\ViewComposers
 */
class BreadcrumbComposer
{
    /**
     * Bind data to the view.
     *
     * @param View $view
     *
     * @return void
     */
    public function compose(View $view)
    {
        // Create the breadcrumbs
        $breadcrumb_label = null;
        $breadcrumbs      = $view->breadcrumbs;

        if (empty($breadcrumbs)) {

            // If this is the home page then just display the label
            if (Request::is('/')) {
                $breadcrumbs[] = 'Home';
                $breadcrumb_label = 'Home';

            } elseif (Request::is('/' . config('settings.backend_prefix'))) { // If this is the admin then display the label
                $breadcrumbs[] = ucwords(config('settings.backend_prefix'));
                $breadcrumb_label = ucwords(config('settings.backend_prefix'));

            } else { // Otherwise get the segments and break into a path
                $uri = preg_replace("/\?.*$/", '', Request::path());
                $exploded_uri = explode('/', trim($uri, '/'));
                $breadcrumbs = [];

                // If this is not the admin then include a link to the home page
                if (!Request::is(config('settings.backend_prefix') . '/*')) {
                    $breadcrumbs[] = ['url' => '/', 'label' => 'Home'];
                }

                $url = '/';
                $count = count($exploded_uri);
                $i = 1;

                foreach ($exploded_uri as $uri) {
                    if (empty($uri)) {
                        continue;
                    }

                    if ($url . $uri === $_SERVER['REQUEST_URI'] || $count === $i) {
                        $breadcrumb_label = ucwords(str_replace(['_', '-'], ' ', $uri));
                        $breadcrumbs[] = $breadcrumb_label;
                        continue;
                    }

                    $url = $url . $uri . '/';
                    $breadcrumbs[] = [
                        'url'   => $url,
                        'label' => ucwords(str_replace(['_', '-'], ' ', $uri)),
                    ];

                    $i++;
                }
            }

            // Pass the data to the view partial
            $view->with(compact('breadcrumbs', 'breadcrumb_label'));
        }
    }
}
