<?php

namespace Bongo\Framework\Models;

use Bongo\Framework\Traits\HasCreatedBy;
use Bongo\Framework\Traits\HasDeletedBy;
use Bongo\Framework\Traits\HasDiff;
use Bongo\Framework\Traits\HasUpdatedBy;
use Illuminate\Database\Eloquent\Model;

/**
 * Class AbstractModel.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Models
 */
abstract class AbstractModel extends Model
{
    use HasCreatedBy,
        HasUpdatedBy,
        HasDeletedBy,
        HasDiff;
}
