<?php

namespace Bongo\Framework\Traits;

use Illuminate\Support\Str;

/**
 * Trait HasContentTrait.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasContent
{
    /**
     * Get the summary attribute.
     *
     * @return string
     */
    public function getSummaryAttribute()
    {
        return $this->getSummary();
    }

    /**
     * Get the summary attribute.
     *
     * @return string
     */
    public function getContentCleanAttribute()
    {
        return $this->getContentClean();
    }

    /**
     * @param int $limit
     *
     * @return string
     */
    public function getSummary($limit = 50)
    {
        return Str::limit(trim(preg_replace('/\s\s+/', ' ', strip_tags($this->content))), $limit);
    }

    /**
     * @return string|string[]|null
     */
    public function getContentClean()
    {
        $content = preg_replace('/(data-noedit|data-module|data-dialog|data-dialog-width|data-settings|data-module-desc|data-html)="[^"]*"/', '', $this->content);

        for ($i=0; $i < 50; $i++) {
            $content = preg_replace('/(data-html-' . $i . ')="[^"]*"/', '', $content);
        }

        return $content;
    }
}
