<?php

namespace Bongo\Framework\Traits;

use Bongo\User\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;

/**
 * Trait HasCreatedBy.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasCreatedBy
{
    /**
     * Boot.
     */
    public static function bootHasCreatedBy()
    {
        static::creating(function ($model) {
            if (Schema::hasColumn($model->getTable(), 'created_by')) {
                $model->created_by = Auth::user() ? Auth::user()->id : null;
            }
        });
    }

    /**
     * Get the user who created the record.
     *
     * @return mixed
     */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by')->withTrashed();
    }

    /**
     * Limit to those created by 'X'.
     *
     * @param      $query
     * @param null $userId
     *
     * @return mixed
     */
    public function scopeByCreator($query, $userId = null)
    {
        return $query->where('created_by', $userId ?? user()->id);
    }
}
