<?php

namespace Bongo\Framework\Traits;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;

/**
 * Trait HasDate
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2022 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasDate
{
    /**
     * Init the trait.
     */
    public function initializeHasDate()
    {
        $this->mergeFillable(['date']);
    }

    /**
     * @param $val
     */
    public function setDateAttribute($val)
    {
        if (!empty($val) && Str::contains($val, '/')) {
            $this->attributes['date'] = Carbon::createFromFormat('d/m/Y', $val);
            return;
        }

        if (!empty($val) && Str::contains($val, '-')) {
            $this->attributes['date'] = $val;
            return;
        }

        $this->attributes['date'] = now()->format('Y-m-d H:i:s');
    }
}
