<?php

namespace Bongo\Framework\Traits;

use Bongo\User\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;

/**
 * Trait HasDeletedBy.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasDeletedBy
{
    /**
     * Boot.
     */
    public static function bootHasDeletedBy()
    {
        static::deleting(function ($model) {
            if (Schema::hasColumn($model->getTable(), 'deleted_by')) {
                $model->deleted_by = Auth::user() ? Auth::user()->id : null;
            }
        });
    }

    /**
     * Get the user who deleted the record.
     *
     * @return mixed
     */
    public function deleter()
    {
        return $this->belongsTo(User::class, 'deleted_by')->withTrashed();
    }

    /**
     * Limit to those deleted by 'X'.
     *
     * @param      $query
     * @param null $userId
     *
     * @return mixed
     */
    public function scopeByDeleter($query, $userId = null)
    {
        return $query->where('deleted_by', $userId ?? user()->id);
    }
}
