<?php

namespace Bongo\Framework\Traits;

/**
 * Trait HasDiff.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasDiff
{
    /**
     * Fetch a diff for the model's current state.
     */
    public function getDiff()
    {
        $changed = $this->getDirty();
        $before  = array_intersect_key($this->fresh()->toArray(), $changed);
        $after   = $changed;

        return compact('before', 'after');
    }
}
