<?php

namespace Bongo\Framework\Traits;

use Illuminate\Contracts\Container\BindingResolutionException;

/**
 * Trait HasHeaderClass
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasHeaderClass
{
    /**
     * Init the trait.
     */
    public function initializeHasHeaderClass()
    {
        $this->mergeFillable(['transparent_header', 'sticky_header']);
    }

    /**
     * @return string
     * @throws BindingResolutionException
     */
    public function getHeaderClass(): string
    {
        $headerClass = '';

        // If transparent header is enabled in the settings and not disabled on the page
        if (setting()->hasTransparentHeader() && $this->hasTransparentHeader()) {
            $headerClass .= ' is-transparent';
        }

        // If sticky header is enabled in the settings and not disabled on the page
        if (setting()->hasStickyHeader() && $this->hasStickyHeader()) {
            $headerClass .= ' is-sticky';
        }

        return $headerClass;
    }

    /**
     * @return bool
     */
    public function hasTransparentHeader(): bool
    {
        return !is_null($this->transparent_header) && intval($this->transparent_header) === 1;
    }

    /**
     * @return bool
     */
    public function hasStickyHeader(): bool
    {
        return !is_null($this->sticky_header) && intval($this->sticky_header) === 1;
    }
}
