<?php

namespace Bongo\Framework\Traits;

use Illuminate\Support\Str;

/**
 * Trait HasUUID.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasUUID
{
    /**
     * Boot.
     */
    public static function bootHasUUID()
    {
        static::creating(function ($model) {
            $model->uuid = (string) Str::uuid();
        });
    }
}
