<?php

namespace Bongo\Framework\Traits;

use Bongo\User\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;

/**
 * Trait HasUpdatedBy.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasUpdatedBy
{
    /**
     * Boot.
     */
    public static function bootHasUpdatedBy()
    {
        static::updating(function ($model) {
            if (Schema::hasColumn($model->getTable(), 'updated_by')) {
                $model->updated_by = Auth::user() ? Auth::user()->id : null;
            }
        });
    }

    /**
     * Get the user who updated the record.
     *
     * @return mixed
     */
    public function updater()
    {
        return $this->belongsTo(User::class, 'updated_by')->withTrashed();
    }

    /**
     * Limit to those updated by 'X'.
     *
     * @param      $query
     * @param null $userId
     *
     * @return mixed
     */
    public function scopeByUpdater($query, $userId = null)
    {
        return $query->where('updated_by', $userId ?? user()->id);
    }
}
