<?php

namespace Bongo\Framework\Traits;

/**
 * Trait VisibleTrait.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Traits
 */
trait HasVisible
{
    /**
     * Init the trait.
     */
    public function initializeHasVisible()
    {
        $this->mergeFillable(['is_visible']);
    }

    /**
     * Visible.
     *
     * @param $query
     *
     * @return mixed
     */
    public function scopeVisible($query)
    {
        return $query->where('is_visible', self::VISIBLE);
    }

    /**
     * Is this record visible.
     *
     * @return bool
     */
    public function isVisible()
    {
        return $this->is_visible === self::VISIBLE;
    }
}
