<footer id="footer" class="footer-1" itemscope itemtype="http://schema.org/LocalBusiness">
    <div class="container">

        <div class="row py-5">
            <div class="col-md-4 mb-4 mb-lg-0">

                <a href="{{ url('/') }}"
                   class="logo pr-0 pr-lg-3"
                   itemprop="image" itemscope
                   itemtype="http://schema.org/ImageObject"
                >
                    <img class="opacity-7 bottom-4 footer-logo"
                         alt="{{ setting("client::company.name") }}"
                         src="{{ setting("theme::logo.light") }}"
                         itemprop="url"
                         data-content="{{ setting("theme::logo.light") }}"
                    >
                </a>

                @if(!empty(setting("theme::layout.footer_text")))
                    <p class="mt-3 mb-2 footer-text">
                        {{ setting("theme::layout.footer_text") }}
                    </p>
                @endif
            </div>

            <div class="col-md-8">
                <h5 class="mb-3">CONTACT US</h5>

                <div class="row">
                    <div class="col-md-6 mb-3 mb-md-0">
                        <ul class="list list-icons list-icons-lg" >

                            @if(setting()->getClientPhoneNumber())
                                <li class="mb-1">
                                    <i class="fab fa-whatsapp text-primary"></i>
                                    <p class="m-0">
                                        <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                                           itemprop="telephone"
                                           data-content="{{ setting()->getClientPhoneNumber() }}"
                                        >
                                            {{ setting()->getClientPhoneNumber() }}
                                        </a>
                                    </p>
                                </li>
                            @endif

                            @if(!empty(setting("client::company.email")))
                                <li class="mb-1">
                                    <i class="far fa-envelope text-primary"></i>
                                    <p class="m-0">
                                        <a href="mailto:{{ setting("client::company.email") }}"
                                           itemprop="email"
                                           data-content="{{ setting("client::company.email") }}"
                                        >
                                            {{ setting("client::company.email") }}
                                        </a>
                                    </p>
                                </li>
                            @endif

                            @if(!empty(setting("client::office.line_1")))
                                <li class="mb-1">
                                    <i class="far fa-dot-circle text-primary"></i>

                                    <p class="m-0"
                                       itemscope
                                       itemtype="http://schema.org/PostalAddress"
                                       itemprop="address"
                                    >
                                        @if(!empty(setting("client::office.line_1")))
                                            <span itemprop="streetAddress">
                                                {{ setting("client::office.line_1") }},
                                            </span>
                                        @endif
                                        @if(!empty(setting("client::office.line_2")))
                                            {{ setting("client::office.line_2") }},
                                        @endif

                                        @if(!empty(setting("client::office.city")))
                                            <span itemprop="addressLocality">
                                                {{ setting("client::office.city") }},
                                            </span>
                                        @endif

                                        @if(!empty(setting("client::office.postcode")))
                                            <span itemprop="postalCode">
                                                {{ setting("client::office.postcode") }}
                                            </span>
                                        @endif
                                    </p>
                                </li>
                            @endif

                        </ul>
                    </div>

                    <div class="col-md-6 footer-menu">
                        @include('menu::frontend.partials.footer_menu', ['key' => 'footer_menu', 'showBullets' => true])
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="footer-copyright">
        <div class="container">
            <div class="row py-3">
                <div class="col d-flex align-items-center justify-content-center">
                    <p>
                        &copy;{{ now()->format('Y') }} <span itemprop="name">{{ setting("client::company.name") }}</span>. All rights reserved.
                        <a href="{{ setting('system::developer.credit_link') }}" {{ setting()->isNoFollow() ? 'rel=nofollow' : '' }}>
                            {{ setting('system::developer.credit_text') }}
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</footer>
