<footer id="footer" class="footer-4" itemscope itemtype="http://schema.org/LocalBusiness">
    <div class="container">

        <div class="row py-5">

            <div class="col-md-7 col-lg-4 mb-5 mb-lg-0 pt-3">
				<a href="{{ url('/') }}"
                   class="logo mb-3"
                   itemprop="image" itemscope
                   itemtype="http://schema.org/ImageObject"
                >
					<img class="opacity-5 footer-logo"
							alt="{{ setting("client::company.name") }}"
							src="{{ setting("theme::logo.light") }}"
							itemprop="url"
							data-content="{{ setting("theme::logo.light") }}"
					>
				</a>
                <h5 class="mb-3">ABOUT US</h5>
                <p class="footer-text">
                    {{ setting("theme::layout.footer_text") }}
                </p>
            </div>

            <div class="col-md-5 col-lg-4 mb-5 mb-lg-0 pt-3">
                <h5 class="mb-3 pb-1">CONTACT US</h5>

                @if(setting()->getClientPhoneNumber())
                    <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                       class="text-lg"
                       itemprop="telephone"
                       data-content="{{ setting()->getClientPhoneNumber() }}"
                    >
                        {{ setting()->getClientPhoneNumber() }}
                    </a>
                @endif

                <ul class="list list-icons list-icons-lg">
                    @if(!empty(setting("client::office.line_1")))
                        <li class="mb-1"
                            itemscope
                            itemtype="http://schema.org/PostalAddress"
                            itemprop="address"
                        >
                            <i class="fas fa-map-marker-alt text-primary"></i>
                            <p class="m-0">
                                @if(!empty(setting("client::office.line_1")))
                                    <span itemprop="streetAddress" class="d-block">
                                        {{ setting("client::office.line_1") }},
                                    </span>
                                @endif

                                @if(!empty(setting("client::office.line_2")))
                                    <span class="d-block">
										{{ setting("client::office.line_2") }},
									</span>
                                @endif

                                @if(!empty(setting("client::office.city")))
                                    <span itemprop="addressLocality" class="d-block">
                                        {{ setting("client::office.city") }},
                                    </span>
                                @endif

                                @if(!empty(setting("client::office.postcode")))
                                    <span itemprop="postalCode" class="d-block">
                                        {{ setting("client::office.postcode") }}
                                    </span>
                                @endif
                            </p>
                        </li>
                    @endif

                    @if(!empty(setting("client::company.email")))
                        <li class="mb-1">
                            <i class="fas fa-envelope text-primary"></i>
                            <p class="m-0">
                                <a href="mailto:{{ setting("client::company.email") }}"
                                   itemprop="email"
                                   data-content="{{ setting("client::company.email") }}"
                                >
                                    {{ setting("client::company.email") }}
                                </a>
                            </p>
                        </li>
                    @endif
                </ul>

                <ul class="social-icons social-icons-light mt-4">

                    @if(!empty(setting("client::social.facebook")))
                        <li class="social-icons-facebook">
                            <a class="social-icon" href="{{ setting("client::social.facebook") }}" target="_blank" title="Facebook">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting("client::social.twitter")))
                        <li class="social-icons-twitter">
                            <a class="social-icon" href="{{ setting("client::social.twitter") }}" target="_blank" title="Twitter">
                                <i class="fab fa-twitter"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting("client::social.instagram")))
                        <li class="social-icons-instagram">
                            <a class="social-icon" href="{{ setting("client::social.instagram") }}" target="_blank" title="Instagram">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting("client::social.youtube")))
                        <li class="social-icons-youtube">
                            <a class="social-icon" href="{{ setting("client::social.youtube") }}" target="_blank" title="Youtube">
                                <i class="fab fa-youtube"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting("client::social.linkedin")))
                        <li class="social-icons-linkedin">
                            <a class="social-icon" href="{{ setting("client::social.linkedin") }}" target="_blank" title="Linkedin">
                                <i class="fab fa-linkedin-in"></i>
                            </a>
                        </li>
                    @endif

                    @if(!empty(setting("client::social.pinterest")))
                        <li class="social-icons-pinterest">
                            <a class="social-icon" href="{{ setting("client::social.pinterest") }}" target="_blank" title="Pinterest">
                                <i class="fab fa-pinterest"></i>
                            </a>
                        </li>
                    @endif

                </ul>
            </div>

            <div class="col-lg-4 pt-3">
                <h5 class="mb-3 pb-1">SEND US A MESSAGE</h5>

                <form class="contact-form" action="{{ route('frontend.enquiry.store') }}" method="POST">
                    <div class="validation">
                        @csrf
                        @honeypot
                        @if(setting()->reCaptchaEnabled())
                            {!! RecaptchaV3::field('enquiry') !!}
                        @endif
                    </div>

                    <div class="form-row">
                        <div class="form-group col">
                            <input class="form-control py-2" name="name"
                                   type="text" value="{{ old('name') }}" maxlength="100"
                                   data-msg-required="Please enter your name."
                                   placeholder="Your Name..."
                                   required
                            >
                        </div>
                    </div>

                    <div class="form-group">
                        <input class="form-control py-2" name="email"
                               type="email" value="{{ old('email') }}" maxlength="100"
                               data-msg-required="Please enter your email address."
                               data-msg-email="Please enter a valid email address."
                               placeholder="Your Email Address..."
                               required
                        >
                    </div>

                    <div class="form-row">
                        <div class="form-group col">
                            <textarea class="form-control" name="message"
                                      maxlength="5000" rows="4"
                                      data-msg-required="Please enter your message."
                                      placeholder="Your Message..."
                                      required
                            >{{ old('message') }}</textarea>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col">
                            <input class="btn btn-primary btn-submit"
                                   type="submit" value="Submit"
                                   data-loading-text="Loading..."
                            >
                        </div>
                    </div>

                </form>

            </div>
        </div>
    </div>

    <div class="footer-copyright">
        <div class="container">
            <div class="row py-3">

                <div class="col-lg-5 d-flex align-items-center justify-content-center justify-content-lg-start mb-4 mb-lg-0">
                    <p>
                        &copy;{{ now()->format('Y') }} <span itemprop="name">{{ setting("client::company.name") }}</span>. All rights reserved.
                        <a href="{{ setting('system::developer.credit_link') }}" {{ setting()->isNoFollow() ? 'rel=nofollow' : '' }}>
                            {{ setting('system::developer.credit_text') }}
                        </a>
                    </p>
                </div>

                <div class="col-lg-7 d-flex align-items-center justify-content-center justify-content-lg-end">
                    <nav id="sub-menu">
                        <ul>
                            @include('menu::frontend.partials.bottom_menu', ['key' => 'footer_menu'])
                        </ul>
                    </nav>
                </div>
            </div>
        </div>

    </div>
</footer>
