
<header
    id="header"
    class="header-5 @yield('header_class', setting()->getHeaderClass())"
    itemscope
    itemtype="http://schema.org/LocalBusiness"
>

    {{-- Header Top --}}
    <div class="header-top">
        <div class="container">
            <div class="row">

                {{-- Header Top Left --}}
                <div class="col-md-6 header-top-left d-none d-md-flex align-items-center">
                    <nav class="sub-navbar">
                        <ul>
                            @include('menu::frontend.partials.top_menu', ['key' => 'top_menu'])
                            @if(setting()->getClientPhoneNumber())
                                <li class="nav-item nav-item-phone">
                                    <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                                       itemprop="telephone"
                                       data-content="{{ setting()->getClientPhoneNumber() }}"
                                    >
                                        <i class="fas fa-phone-alt"></i>
                                        {{ setting()->getClientPhoneNumber() }}
                                    </a>
                                </li>
                            @endif
                        </ul>
                    </nav>
                </div>

                {{-- Header Top Right --}}
                <div class="col-md-6 header-top-right d-flex align-items-center justify-content-center justify-content-md-end">
                    <nav class="sub-navbar">
                        <ul class="social-icons social-icons-clean">

                            @if(!empty(setting("client::social.facebook")))
                                <li class="social-icons-facebook">
                                    <a class="social-icon" href="{{ setting("client::social.facebook") }}" target="_blank" title="Facebook">
                                        <i class="fab fa-facebook-f"></i>
                                    </a>
                                </li>
                            @endif

                            @if(!empty(setting("client::social.twitter")))
                                <li class="social-icons-twitter">
                                    <a class="social-icon" href="{{ setting("client::social.twitter") }}" target="_blank" title="Twitter">
                                        <i class="fab fa-twitter"></i>
                                    </a>
                                </li>
                            @endif

                            @if(!empty(setting("client::social.instagram")))
                                <li class="social-icons-instagram">
                                    <a class="social-icon" href="{{ setting("client::social.instagram") }}" target="_blank" title="Instagram">
                                        <i class="fab fa-instagram"></i>
                                    </a>
                                </li>
                            @endif

                            @if(!empty(setting("client::social.youtube")))
                                <li class="social-icons-youtube">
                                    <a class="social-icon" href="{{ setting("client::social.youtube") }}" target="_blank" title="Youtube">
                                        <i class="fab fa-youtube"></i>
                                    </a>
                                </li>
                            @endif

                            @if(!empty(setting("client::social.linkedin")))
                                <li class="social-icons-linkedin">
                                    <a class="social-icon" href="{{ setting("client::social.linkedin") }}" target="_blank" title="Linkedin">
                                        <i class="fab fa-linkedin-in"></i>
                                    </a>
                                </li>
                            @endif

                            @if(!empty(setting("client::social.pinterest")))
                                <li class="social-icons-pinterest">
                                    <a class="social-icon" href="{{ setting("client::social.pinterest") }}" target="_blank" title="Pinterest">
                                        <i class="fab fa-pinterest"></i>
                                    </a>
                                </li>
                            @endif

                        </ul>
                    </nav>
                </div>

            </div>
        </div>
    </div>

    {{-- Header Middle--}}
    <div class="header-middle">
        <div class="container">
            <div class="row">

                {{-- Header Middle Left --}}
                <div class="col-6 col-lg-4 header-middle-left d-flex align-items-center">

                    {{-- Logo --}}
                    <a class="navbar-brand"
                       href="{{ url('/') }}"
                       itemprop="image" itemscope
                       itemtype="http://schema.org/ImageObject"
                    >
                        <img class="header-logo"
                             alt="{{ setting("client::company.name") }}"
                             src="{{ setting("theme::logo.default") }}"
                             itemprop="url"
                             data-content="{{ setting("theme::logo.default") }}"
                        >
                    </a>
                </div>

                {{-- Header Middle Right --}}
                <div class="col-6 col-lg-8 header-middle-right d-flex flex-wrap align-items-center justify-content-end flex-lg-nowrap text-right">
                    @if(!empty(setting("client::company.email")))
                        <div class="header-text order-2 order-lg-1 d-none d-md-block">
                            <span class="d-block">
                                SEND US AN EMAIL
                            </span>
                            <a class="d-block"
                               href="mailto:{{ setting("client::company.email") }}"
                               itemprop="email"
                               data-content="{{ setting("client::company.email") }}"
                            >
                                {{ strtoupper( setting("client::company.email")) }}
                            </a>
                        </div>
                    @endif
                    @if(setting()->getClientPhoneNumber())
                        <div class="header-text order-1 order-lg-2 ml-lg-5 mr-md-3 mr-lg-0">
                            <span class="d-block">
                                CALL US NOW
                            </span>
                            <a class="d-block"
                               href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}"
                               itemprop="telephone"
                               data-content="{{ setting()->getClientPhoneNumber() }}"
                            >
                                {{ setting()->getClientPhoneNumber() }}
                            </a>
                        </div>
                    @endif
                </div>

            </div>
        </div>
    </div>

    {{-- Header Bottom--}}
    <div class="header-bottom">
        <nav class="navbar navbar-expand-lg">
            <div class="container">

                {{-- Burger Menu --}}
                <button class="navbar-toggler"
                        type="button"
                        data-toggle="collapse"
                        data-target="#navbarNavDropdown"
                        aria-controls="navbarNavDropdown"
                        aria-expanded="false"
                        aria-label="Toggle navigation"
                >
                    <i class="fas fa-bars"></i>
                </button>

                {{-- Main Menu --}}
                <div class="collapse navbar-collapse" id="navbarNavDropdown">
                    <ul class="navbar-nav">
                        @include('menu::frontend.partials.main_menu', ['key' => 'main_menu'])
                    </ul>
                </div>

            </div>
        </nav>
    </div>

</header>
