<!DOCTYPE html>
<html itemscope itemtype="http://schema.org/Article" lang="{{ app()->getLocale() }}">

    <head>
        @include('framework::frontend.layouts.partials.analytics')
        @include('framework::frontend.layouts.partials.pixel')

        @php
            $version   = setting('system::misc.version');
            $pageUrl   = preg_replace("/\?.*$/", '', request()->path());
            $pageTitle = request()->segment(count(request()->segments()));
            $pageTitle = ucwords(str_replace(['_', '-'], ' ', $pageTitle));
            $pageClass = request()->segment(1) ? str_singular(request()->segment(1)) . '-page' : '';

            $metaTitle = ucwords(str_replace(['/'], ' > ', $pageUrl));
            $metaTitle = ucwords(str_replace(['_', '-'], ' ', $metaTitle));
        @endphp

        <title>@yield('meta_title', $metaTitle)</title>
        @include('framework::frontend.layouts.partials.meta_standard')
        @include('framework::frontend.layouts.partials.meta_schema')
        @include('framework::frontend.layouts.partials.meta_open_graph')
        @include('framework::frontend.layouts.partials.meta_twitter')
        @include('framework::frontend.layouts.partials.favicon')

        @section('header_css')
            <link href="{{ asset("/css/frontend.css?{$version}") }}" rel="stylesheet" type="text/css" />
        @show
        @section('header_javascript')
            @if(setting()->reCaptchaEnabled())
                {!! RecaptchaV3::initJs() !!}
            @endif
        @show
    </head>

    <body class="@yield('body_class', $pageClass)">
        @include('framework::frontend.layouts.partials.analytics_no_js')
        @include('framework::frontend.layouts.partials.pixel_no_js')

        <div id="app" v-cloak>
            @section('main')
                @include('framework::frontend.layouts.partials.main')
            @show
            @section('messages')
                @include('framework::frontend.layouts.partials.message')
            @show
            @section('cookies')
                @include('framework::frontend.layouts.partials.cookie_consent')
                @include('framework::frontend.layouts.partials.cookie_manager')
                @include('framework::frontend.layouts.partials.cookie_btn')
            @show
        </div>

        {{-- Footer Javascript files --}}
        @section('footer_javascript')
            <script defer src="{{ asset("/js/frontend.js?{$version}") }}" type="text/javascript"></script>
        @show
    </body>
</html>
