<?php

namespace Bongo\Framework\Events;

use Exception;

class AbstractEventHandler
{
    protected string $model;

    /**
     * @throws Exception
     */
    public function subscribe($events): void
    {
        if (empty($this->model)) {
            throw new Exception('Please set the model attribute for this event handler');
        }

        $events->listen('eloquent.retrieved: '.$this->model, get_called_class().'@onRetrieved');
        $events->listen('eloquent.creating: '.$this->model, get_called_class().'@onCreating');
        $events->listen('eloquent.created: '.$this->model, get_called_class().'@onCreate');
        $events->listen('eloquent.updating: '.$this->model, get_called_class().'@onUpdating');
        $events->listen('eloquent.updated: '.$this->model, get_called_class().'@onUpdate');
        $events->listen('eloquent.deleting: '.$this->model, get_called_class().'@onDeleting');
        $events->listen('eloquent.deleted: '.$this->model, get_called_class().'@onDelete');
        $events->listen('eloquent.saving: '.$this->model, get_called_class().'@onSaving');
        $events->listen('eloquent.saved: '.$this->model, get_called_class().'@onSave');
    }

    public function onRetrieved($model): void
    {
    }

    public function onCreating($model): void
    {

    }

    public function onCreate($model): void
    {
    }

    public function onUpdating($model): void
    {

    }

    public function onUpdate($model): void
    {
    }

    public function onDeleting($model): void
    {

    }

    public function onDelete($model): void
    {
    }

    public function onSaving($model): void
    {
    }

    public function onSave($model): void
    {
    }
}
