<?php

declare(strict_types=1);

namespace Bongo\Framework\Helpers;

use Illuminate\Support\Str as StrFacade;

class Str
{
    public static function noTags(string $input): string
    {
        return strip_tags($input);
    }

    public static function singleSpace(string $input): string
    {
        return preg_replace('/\s\s+/', ' ', $input);
    }

    public static function noSpace(string $input): string
    {
        return preg_replace('/\s\s+/', '', $input);
    }

    public static function camelWords(string $input, bool $plural = false): string
    {
        $input = str_replace(['-', '_'], ' ', $input);

        if ($plural) {
            $words = explode(' ', $input);
            if ($pluralized = StrFacade::plural(array_pop($words))) {
                $words = array_merge($words, [$pluralized]);
            }
            $input = implode(' ', $words);
        }

        $input = lcfirst(ucwords($input));

        return str_replace(' ', '', $input);
    }

    public static function dotNotation(string $input): string
    {
        $input = str_replace('[', '.', $input);

        return str_replace(']', '', $input);
    }

    public static function id(string $input, ?string $append): string
    {
        $input = str_replace('/', '-', $input);
        $input = str_replace('.', '-', $input);
        $input = str_replace('[', '-', $input);
        $input = str_replace(']', '-', $input);
        $input = StrFacade::kebab($input);
        $input = StrFacade::slug($input, '-');
        $input = trim($input);
        $input = strtolower($input);

        return $input.$append;
    }

    public static function key(string $input): string
    {
        $input = str_replace('/', '_', $input);
        $input = str_replace('.', '_', $input);
        $input = StrFacade::slug($input, '_');
        $input = trim($input);

        return strtolower($input);
    }

    public static function plainFloat(string $input): string
    {
        return trim(preg_replace('/[^\d.-]/', '', $input));
    }

    public static function plainNumber(string $input): string
    {
        return trim(preg_replace('/\D/', '', $input));
    }

    public static function plainText(string $input): string
    {
        return trim(self::singleSpace(self::noTags($input)));
    }

    public static function plainLowerText(string $input): string
    {
        return strtolower(self::plainText($input));
    }

    public static function plainUpperText(string $input): string
    {
        return strtoupper(self::plainText($input));
    }

    public static function plainWords(string $input): string
    {
        return ucwords(strtolower(self::plainText($input)));
    }

    public static function asAcronym(string $input): string
    {
        $words = explode(' ', $input);

        $acronym = '';
        foreach ($words as $word) {
            $acronym .= $word[0];
        }

        return strtoupper($acronym);
    }
}
