<?php

namespace Bongo\Framework\Schema\Concerns;

use Illuminate\Contracts\Container\BindingResolutionException;

trait HandlesContactPoint
{
    /** @throws BindingResolutionException */
    public function addContactPoint(): self
    {
        $this->contactPoint($this->contactPointId)
            ->identifier($this->contactPointId)
            ->telephone($this->getContactPointPhone())
            ->email($this->getContactPointEmail())
            ->contactType($this->getContactPointType())
            ->areaServed($this->getContactPointAreaServed());

        return $this;
    }

    /** @throws BindingResolutionException */
    protected function getContactPointPhone(): ?string
    {
        return setting('client::company.phone') ?? '--';
    }

    /** @throws BindingResolutionException */
    protected function getContactPointEmail(): ?string
    {
        return setting('client::company.email') ?? '--';
    }

    protected function getContactPointType(): string
    {
        return 'customer service';
    }

    protected function getContactPointAreaServed(): string
    {
        return 'Worldwide';
    }
}
