<?php

namespace Bongo\Framework\Schema\Concerns;

use Illuminate\Contracts\Container\BindingResolutionException;

trait HandlesFounder
{
    /** @throws BindingResolutionException */
    public function addFounder(): self
    {
        $this->person($this->founderId)
            ->identifier($this->founderId)
            ->name($this->getFounderName())
            ->jobTitle($this->getFounderJobTitle())
            ->email($this->getFounderEmail())
            ->telephone($this->getFounderPhone());

        return $this;
    }

    /** @throws BindingResolutionException */
    protected function getFounderName(): ?string
    {
        return setting('client::company.name') ?? '--';
    }

    /** @throws BindingResolutionException */
    protected function getFounderJobTitle(): ?string
    {
        return setting('client::company.founder_job_title') ?? '--';
    }

    /** @throws BindingResolutionException */
    protected function getFounderEmail(): ?string
    {
        return setting('client::company.email') ?? '--';
    }

    /** @throws BindingResolutionException */
    protected function getFounderPhone(): ?string
    {
        return setting('client::company.phone') ?? '--';
    }
}
