<?php

namespace Bongo\Framework\Schema\Concerns;

trait HandlesOutput
{
    public function toArray(): array
    {
        $nodes = $this->getNodes();

        foreach ($this->hidden as $type => $hideAll) {
            if (is_bool($hideAll) && $hideAll) {
                unset($nodes[$type]);

                continue;
            }

            if (is_array($hideAll)) {
                foreach ($hideAll as $identifier => $hide) {
                    if (is_bool($hide) && $hide) {
                        unset($nodes[$type][$identifier]);
                    }
                }
            }
        }

        $nodes = array_reduce($nodes, function (array $carry, array $types) {
            return array_merge($carry, array_values($types));
        }, []);

        $graphArray = $this->serializeNode(array_values($nodes));

        // Check if we have any valid global custom schema to append
        $customSchema = setting()->getCustomSchema();
        if (! empty($customSchema) && json_validate($customSchema)) {
            $customSchema = json_decode($customSchema, true);
            $graphArray[] = $customSchema;
        }

        // Check if the entity has specific schema
        // @todo Check if the entity has specific schema

        return [
            '@context' => $this->getContext(),
            '@graph' => $graphArray,
        ];
    }
}
