<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Contact;

trait HasFullName
{
    public function initializeHasFullName(): void
    {
        $this->append('full_name');
        $this->mergeFillable(['full_name']);
    }

    public function getFullNameAttribute(): ?string
    {
        if (! empty($this->first_name) && ! empty($this->last_name)) {
            return $this->first_name.' '.$this->last_name;
        }

        return null;
    }

    public function setFullNameAttribute(?string $value): void
    {
        if (! empty($value)) {
            $splitName = explode(' ', $value);

            $this->attributes['first_name'] = $splitName[0] ?? null;
            $this->attributes['last_name'] = $splitName[1] ?? null;
        }
    }
}
