<?php

declare(strict_types = 1);

namespace Bongo\Framework\Traits\Contact;

use Bongo\Framework\Casts\PlainNumber;
use Illuminate\Database\Eloquent\Casts\Attribute;

trait HasMobile
{
    public function initializeHasMobile(): void
    {
        $this->mergeFillable([
            'mobile',
            'mobile_prefix',
        ]);

        $this->mergeCasts([
            'mobile' => PlainNumber::class,
            'mobile_prefix' => 'string',
        ]);
    }

    public function hasMobile(): bool
    {
        return ! empty($this->mobile);
    }

    public function hasMobilePrefix(): bool
    {
        return ! empty($this->mobile_prefix);
    }

    public function mobileFull(): Attribute
    {
        return Attribute::make(get: function () {
            return $this->hasMobilePrefix() && $this->hasMobile()
                ? $this->mobile_prefix.$this->mobile
                : $this->mobile;
        });
    }
}
