# Changelog

All notable changes to `bongo/framework` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.35] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` - GitHub Copilot code templates and patterns
  - Enhanced `README.md` with comprehensive user-facing documentation
- **HasRecursive Trait**: New trait for hierarchical parent/child relationships (DT-551)
  - `parent()`, `children()`, `nestedChildren()` relationships
  - Helper methods: `getAncestors()`, `getDescendents()`, `siblings()`
  - Check methods: `hasParent()`, `hasChildren()`, `isParent()`, `isChild()`
  - Automatic ordering by `sort_id` field
- **Schema.org Graph Generation System**: Complete rewrite of SEO schema generation (DT-518)
  - New `MetaSchema` class as the main entry point for schema generation
  - Graph-based architecture with `PageGraph`, `PostGraph`, `ProjectGraph` classes
  - Modular concerns for different schema types:
    - `HandlesArticle` - Article schema for blog posts
    - `HandlesBlogPost` - BlogPosting schema for blog content
    - `HandlesWebPage` - WebPage schema for standard pages
    - `HandlesWebSite` - WebSite schema for site-wide data
    - `HandlesLocalBusiness` - LocalBusiness schema with business details
    - `HandlesOrganization` - Organization schema with company information
    - `HandlesReviews` - Review and AggregateRating schema support
    - `HandlesSocialLinks` - Social media profile linking
    - `HandlesAuthor` - Person schema for content authors
    - `HandlesContactPoint` - ContactPoint schema for business contact
    - `HandlesPostalAddress` - PostalAddress schema for locations
    - `HandlesGeoCoordinates` - GeoCoordinates schema for map data
    - `HandlesPlace` - Place schema wrapper
    - `HandlesEntity` - Generic entity handling
    - `HandlesFounder` - Founder/founder relationship
    - `HandlesReferenceIds` - @id reference system for linked data
    - `HandlesOutput` - JSON-LD script tag generation
  - New `config/schema.php` configuration file for organization details
  - Updated `SEO::getMetaSchemaForPage()`, `SEO::getMetaSchemaForPost()`, `SEO::getMetaSchemaForProject()` helper methods
- **Captcha Integration**: Custom captcha functionality
  - Replaced `anhskohbo/no-captcha` with custom `bongo/captcha` package
  - Added captcha JavaScript validation to frontend layouts
  - Updated `app.blade.php` and `wizard.blade.php` layouts with captcha support
  - Registered `CaptchaServiceProvider` in FrameworkServiceProvider
- **OpenAI Package Support**: Conditional loading of OpenAI package if enabled (DT-485)
  - Added `OpenAIServiceProvider` registration in FrameworkServiceProvider
- **Address Traits**: Comprehensive address field traits for model standardization
  - `HasCity` - City name field
  - `HasCounty` - County/state field
  - `HasLine1`, `HasLine2`, `HasLine3` - Address line fields
  - `HasPostcode` - Postal/ZIP code field
  - `HasLatitude` - Latitude coordinate with accessor/mutator
  - `HasLongitude` - Longitude coordinate with accessor/mutator
- **Contact Traits**: Standardized contact information traits
  - `HasEmail` - Email address field with accessor
  - `HasPhone` - Phone number field with formatting
  - `HasMobile` - Mobile number field with formatting
  - `HasFirstName`, `HasLastName` - Name component fields
  - `HasFullName` - Combined full name accessor
  - `HasWebsite` - Website URL field
  - `HasSocial` - Social media handles
  - `HasAcceptedTerms` - Terms acceptance flag
  - `HasMarketingEmails`, `HasMarketingSms` - Marketing consent flags
  - `HasNotificationEmails`, `HasNotificationSms` - Notification preference flags
- **Audit Traits**: Separated audit trail functionality into individual traits
  - `HasCreatedAt` - Created timestamp
  - `HasCreatedBy` - Created by user relationship
  - `HasUpdatedAt` - Updated timestamp
  - `HasUpdatedBy` - Updated by user relationship
  - `HasDeletedAt` - Soft delete timestamp
  - `HasDeletedBy` - Deleted by user relationship
  - `HasDiff` - Track model changes between saves
- **PHP 8.1+ Enums**: Modern enum implementations replacing database enums
  - `BooleanEnum` - YES (1) / NO (0) integer enum
  - `StatusEnum` - ACTIVE (1) / DISABLED (0) integer enum
  - `ArrayInterface` - Interface for enum array conversion
  - `DefaultInterface` - Interface for default enum values
  - `WithArray` - Trait providing `toArray()` and `getDefault()` methods
  - Global aliases registered for `BooleanEnum` and `StatusEnum`
- **Custom Eloquent Casts**: Type-safe data casting for models
  - `Encoded` - HTML entity encoding/decoding cast
  - `Pence` - Pence to pounds conversion (stores pence, returns pounds)
  - `PlainText` - Strip HTML tags cast
  - `PlainLowerText` - Lowercase text cast
  - `PlainUpperText` - Uppercase text cast
  - `PlainNumber` - Numeric-only cast
  - `PlainWords` - Word characters only cast
  - `Checkbox` - Checkbox boolean cast
  - `Domain` - Domain name validation cast
  - `Date` - Date formatting cast (renamed from DateCast)
  - `DateTime` - DateTime formatting cast (renamed from DateTimeCast)
  - `Time` - Time formatting cast (renamed from TimeCast)
- **Helper Classes**: Organized helper functionality into dedicated classes
  - `Str` - String utilities: `camelWords()`, `key()`, `id()`, `float()` (supports negative values)
  - `Route` - Route helpers: `route_exists()`, `route_is()`
  - `Cookie` - Cookie helpers: `cookie_enabled()`
  - `Password` - Password generation: `generate_password()`
  - `Log` - Exception logging: `log_exception()`
  - `Console` - Console output helpers
  - `SEO` - Schema.org generation helpers
- **StatusInterface**: Interface for models with status functionality
- **MinifyHtml Middleware**: HTML minification middleware for production (DT-390)
  - Configurable via `minify_html_enabled` setting
- **NoIndex Middleware**: Adds noindex meta tag to prevent search engine indexing (DT-313)
  - Registered as route middleware
- **CloudFlare Helper**: CloudFlare API integration (DT-295)
  - Cache purging functionality
  - New `config/cloudflare.php` configuration file
  - API credentials management
- **ReCaptcha Integration**: Google ReCaptcha v3 support (DT-417)
  - Added `anhskohbo/no-captcha` dependency
  - Updated frontend layouts with ReCaptcha scripts
  - Added error message display in forms
- **Wizard Layout**: New wizard-style frontend layout template
  - Multi-step form support
  - Meta schema integration
  - Analytics and tracking support

### Changed
- **Laravel 10 Upgrade**: Full framework upgrade to Laravel 10.x compatibility
  - Updated all middleware to Laravel 10 signatures
  - Updated exception handler to Laravel 10 structure
  - Updated service providers to Laravel 10 conventions
  - Removed deprecated methods and classes
- **PHP 8.2 Requirement**: Minimum PHP version now 8.2
  - Added strict types declarations
  - Removed legacy PHP 7 compatibility code
  - Updated type hints throughout codebase
- **AbstractServiceProvider Refactoring**: Simplified and improved service provider base class
  - Streamlined route registration logic
  - Improved config merging
  - Better middleware registration
  - Enhanced package loading sequence
- **AbstractDatatableController Improvements**: Enhanced DataTables controller base
  - Simplified query building
  - Better filter application
  - Improved performance
- **FrameworkServiceProvider Updates**: Reorganized package loading
  - Conditional package loading based on configuration
  - Better boot sequence management
  - Installation check improvements
  - Removed database dependency during install package loading
- **AbstractModel Enhancements**: Updated base model class
  - Reorganized trait usage with new Audit namespace
  - Added `attributeExists()` helper method
  - Better relationship management
- **Trait Reorganization**: Moved traits into logical namespaces
  - Moved `HasCreatedBy`, `HasUpdatedBy`, `HasDeletedBy` to `Audit` namespace
  - Created `Address` namespace for address-related traits
  - Created `Contact` namespace for contact information traits
- **Helper Function Refactoring**: Cleaned up global helper functions
  - Moved complex logic to dedicated helper classes
  - Reduced helper.php from 300+ lines to focused essentials
  - Better organization and discoverability
- **SEO Helper Refactoring**: Complete rewrite for graph-based schema
  - Removed monolithic schema generation
  - Delegated to specialized schema graph classes
  - Improved maintainability and extensibility
- **HasRecursive Trait**: Always orders by `sort_id` in recursive queries
- **HasContent Trait**: Added space preservation in schema body content (DT-472)
- **HasStatus Trait**: Updated to work with new `StatusEnum`
- **HasHeaderClass Trait**: Enhanced transparent/sticky header functionality (DT-306)
- **Frontend Message Partial**: Improved error notification display (DT-544)
  - Better error message formatting
  - Enhanced validation error display
- **Frontend Layout Updates**: Modernized frontend templates
  - Removed header/footer template partials (moved to theme package) (DT-305)
  - Removed heading partials 1-5
  - Updated analytics tracking
  - Enhanced cookie consent management
  - Improved meta tag generation
- **PackageComposer**: Updated view composer for new settings structure (DT-304)
  - Removed hard-coded header/footer template references
- **ShortCode Helper**: Added office address shortcode support (DT-335)
- **Tax Helper**: Updated VAT calculation logic (DT-371)
- **File Helper**: Enhanced file handling methods
- **Html Helper**: Added content formatting methods (DT-426)
- **URL Helper**: Simplified URL manipulation methods
- **BreadcrumbComposer**: Updated for Laravel 10 compatibility
- **Frontend Analytics**: Enhanced Google Analytics 4 support
  - Improved tracking code
  - Better cookie consent integration
- **Cookie Consent**: Updated text and styling (DT-302)

### Deprecated
- Old trait locations (moved to namespaced versions)
  - `HasCreatedBy` → `Audit\HasCreatedBy`
  - `HasUpdatedBy` → `Audit\HasUpdatedBy`
  - `HasDeletedBy` → `Audit\HasDeletedBy`
  - `HasDiff` → `Audit\HasDiff`

### Removed
- **Deleted Traits**: Consolidated into namespaced versions
  - `src/Traits/HasCreatedBy.php` (moved to Audit namespace)
  - `src/Traits/HasUpdatedBy.php` (moved to Audit namespace)
  - `src/Traits/HasDeletedBy.php` (moved to Audit namespace)
  - `src/Traits/HasDiff.php` (moved to Audit namespace)
  - `src/Traits/HasKey.php` (functionality moved to helpers)
- **Deleted Frontend Partials**: Template-specific files moved to theme package (DT-305)
  - `footer_1.blade.php` through `footer_5.blade.php`
  - `header_1.blade.php` through `header_5.blade.php`
  - `heading_1.blade.php` through `heading_5.blade.php`
- **Deleted Middleware**: Replaced by Laravel 10 equivalents
  - `CheckForMaintenanceMode` (replaced by `PreventRequestsDuringMaintenance`)
- **Deleted Controllers**: Unused abstract controllers
  - `AbstractApiController` (functionality merged into AbstractController)
- **Deleted Helpers**: Deprecated helper classes
  - `Referrer` (functionality no longer needed)
- **Deleted Schema Files**: Old monolithic schema approach
  - `ArticleGraph.php` (replaced by PostGraph and concern-based system)
  - `HandlesArticleSchema.php` (split into HandlesArticle and HandlesBlogPost)
- **composer.lock**: Removed from version control (development artifact)
- **anhskohbo/no-captcha** dependency: Replaced with custom `bongo/captcha` package

### Fixed
- **Install Package Database Connection**: Fixed premature database connection during installation (DT-361)
  - System no longer tries to connect to database when loading install package
  - Database connection deferred until configuration complete
- **Frontend Notification Errors**: Fixed error message display (DT-544)
  - Validation errors now display correctly
  - Better formatting for multiple errors
- **Schema Body Content**: Fixed missing spaces in content extraction (DT-472)
  - Content now preserves proper spacing between elements
- **Str::float() Helper**: Now accepts negative float values
- **HasRecursive Ordering**: Recursive relationships now consistently order by `sort_id`
- **Schema Individual Pages**: Fixed schema output for individual pages (DT-518)
- **Boot Sequence**: Ensured APP_KEY is generated before package loading
- **Installation Tables**: Added check for existing tables before creation

### Security
- Updated all dependencies to latest secure versions
- Enhanced CSRF protection
- Improved input sanitization with PlainText casts

## [2.0.71] - 2024-10-07

### Changed
- Updated authentication credentials in `auth.json`
- Updated `.editorconfig` and `.styleci.yml` configurations
- Updated README documentation

### Fixed
- Minor bug fixes and improvements

## [2.0.70] - 2024-08-05

### Added
- Excel export functionality via `maatwebsite/excel`

### Changed
- Updated composer dependencies

---

**Package**: `bongo/framework`
**Repository**: https://bitbucket.org/designtec/framework
