<?php

declare(strict_types=1);

namespace Bongo\Framework\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class Checkbox implements CastsAttributes
{
    public function get($model, string $key, $value, array $attributes): int
    {
        return (int) $value;
    }

    public function set($model, string $key, $value, array $attributes): int
    {
        if (is_string($value)) {
            return $value === 'on' || $value === '1' ? 1 : 0;
        }

        if (is_bool($value)) {
            return $value ? 1 : 0;
        }

        if (is_numeric($value)) {
            return intval($value) === 1 ? 1 : 0;
        }

        return 0;
    }
}
