<?php

declare(strict_types=1);

namespace Bongo\Framework\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class Encoded implements CastsAttributes
{
    public function get($model, string $key, $value, array $attributes): ?string
    {
        return $value ? html_entity_decode($value) : null;
    }

    public function set($model, string $key, $value, array $attributes): ?string
    {
        return $value ? htmlentities($value) : $value;
    }
}
