<?php

namespace Bongo\Framework\Helpers;

use DOMDocument;

class Html
{
    public static function parse(string $input): ?string
    {
        libxml_use_internal_errors(true);

        // Encode the html
        $input = htmlentities($input);
        $input = htmlspecialchars($input);

        // Parses the markup and return valid html
        $domDocument = new DOMDocument();
        $domDocument->loadHTML('<html>'.$input.'</html>', LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
        $input = $domDocument->saveHTML($domDocument->documentElement);

        // Decode the html
        $input = htmlspecialchars_decode($input);
        $input = html_entity_decode($input);

        return str_replace(['<html>', '</html>'], '', $input);
    }

    public static function wrapIcons(string $input): ?string
    {
        return preg_replace('/#icon(?:-mi)?\[(.*?)]#/i', "<i class=\"fas fa-$1\"></i>", $input);
    }

    public static function wrapShortCodes(string $input): ?string
    {
        return preg_replace('/#(.*?)#/i', "<b>[$1]</b>", $input);
    }

    public static function removeClasses(string $input): ?string
    {
        return preg_replace('/(<[^>]+) class=".*?"/i', '$1', $input);
    }

    public static function removeStyles(string $input): ?string
    {
        return preg_replace('/(<[^>]+) style=".*?"/i', '$1', $input);
    }

    public static function removeDataAttributes(string $input): ?string
    {
        return preg_replace(
            '/(data-src|data-mfp-src|data-preset|data-width|data-height|data-mode|data-group|data-path|data-name|data-cta-title|data-cta-url|data-cta-target|draggable)="[^"]*"/',
            '', $input
        );
    }

    public static function removeJavascript(string $input): ?string
    {
        return preg_replace('@<(script|style)[^>]*?>.*?</\\1>@si', '', $input);
    }

    public static function removeTags(string $input, array $allowedTags = []): ?string
    {
        return strip_tags($input, $allowedTags);
    }

    public static function removeEmptyTags(string $input): ?string
    {
        return preg_replace('/<[^\/>]*>(\s?)*<\/[^>]*>/i', '', $input);
    }
}
