<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Contact;

use Bongo\Framework\Casts\Domain;

trait HasSocial
{
    public function initializeHasSocial(): void
    {
        $this->mergeFillable([
            'facebook',
            'twitter',
            'instagram',
            'youtube',
            'linkedin',
            'tiktok',
            'pinterest',
        ]);

        $this->mergeCasts([
            'facebook' => Domain::class,
            'twitter' => Domain::class,
            'instagram' => Domain::class,
            'youtube' => Domain::class,
            'linkedin' => Domain::class,
            'tiktok' => Domain::class,
            'pinterest' => Domain::class,
        ]);
    }
}
