<?php

declare(strict_types=1);

namespace Bongo\Framework\Traits\Contact;

use Bongo\Framework\Casts\Domain;
use Bongo\Framework\Helpers\URL;
use Illuminate\Database\Eloquent\Casts\Attribute;

trait HasWebsite
{
    public function initializeHasWebsite(): void
    {
        $this->mergeFillable(['website']);
        $this->mergeCasts(['website' => Domain::class]);
    }

    public function hasWebsite(): bool
    {
        return ! empty($this->website);
    }

    public function websiteFull(): Attribute
    {
        return Attribute::make(get: function () {
            return ! empty($this->website)
                ? URL::asHttps($this->website)
                : $this->website;
        });
    }
}
