@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('gallery::backend.index') }}
        @slot('actions')
            @backButton(['name' => trans('dashboard::backend.index')])
            @createButton(['name' => trans('gallery::backend.create'), 'url' => route('backend.gallery.create')])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <data-table
            search-url="{{ route('backend.gallery.datatable') }}"
            resource-url="{{ route('backend.gallery.index') }}"
            order-by="name"
            order-direction="asc"
            v-cloak
        >
            <template slot="default" slot-scope="{items, itemIndex, isSelected, setAsSelectedItem, viewUrl, editUrl}">
                <div class="grid md:grid-cols-2 gap-3">

                    <v-card
                        v-for="(item, index) in items"
                        :key="item.id"
                        :id="itemIndex(item, index)"
                        :class="['col-span-1', { selected : isSelected(item, index) }]"
                        @click="setAsSelectedItem(item, index)"
                    >
                        <template slot="left">
                            <a :href="viewUrl(item)" title="View"
                               class="block font-semibold hover:text-primary-500 focus:text-primary-600 flex items-center"
                            >
                                @{{ item.name }}
                            </a>
                        </template>

                        <template slot="right">
                            <v-button :link="viewUrl(item)">View</v-button>
                        </template>
                    </v-card>

                </div>
            </template>
        </data-table>
    @endcomponent
@stop
