<section class="md:grid md:grid-cols-2 md:gap-6">
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 lg:grid-cols-2">
                <div class="lg:col-span-1">
                    @input([
                    'label' => 'Gallery Name',
                    'name' => 'name',
                    'value' => $gallery->name,
                    'required' => 'true'
                    ])
                </div>
            </div>
        @endcomponent
    </div>
    <div class="md:col-span-1">
        @component('blade::card')
            @select([
            'name'     => 'status',
            'value'    => $gallery->status,
            'options'  => get_enum_values('galleries', 'status')
            ])
        @endcomponent
    </div>
</section>

<section>
    <gallery-builder
        :gallery="{{ json_encode($gallery) }}"
        index-url="{{ route('api.gallery.index', $gallery->id) }}"
        store-url="{{ route('api.gallery.store', $gallery->id) }}"
        update-url="{{ route('api.gallery.update', $gallery->id) }}"
        delete-url="{{ route('api.gallery.destroy', $gallery->id) }}"
        image-url="{{ config('image.prefix') }}"
    ></gallery-builder>
</section>
