<div class="grid grid-cols-{{ $columns ?? 1 }} gap-{{ $padding ?? 0 }}">
    @foreach($gallery->images as $image)
        <div class="grid-item">
            @if($lightbox)
                <div class="image-wrapper">
                    <img class="image has-lightbox {{ $lazy ? 'lazyload' : '' }}"
                         src="{!! route('frontend.image.show', [
                            'image' => $image,
                            'preset' => 'medium',
                            'q' => ($lazy ? '5' : ($quality ?? config('image.quality')))
                         ]) !!}"
                         data-src="{!! route('frontend.image.show', [
                            'image' => $image,
                            'preset' => $preset ?? 'medium',
                            'q' => ($quality ?? config('image.quality'))
                         ]) !!}"
                         data-mfp-src="{!! route('frontend.image.show', [
                            'image' => $image,
                            'preset' => 'full',
                         ]) !!}"
                         alt="{{ $image->title }}"
                         loading="{{ $lazy ? 'lazy' : 'null' }}"
                         data-group="{{ $lightbox ? (100 + $gallery->id) : '' }}"
                    />
                </div>
            @else
                <div class="image-wrapper">
                    <img class="image {{ $lazy ? 'lazyload' : '' }}"
                         src="{!! route('frontend.image.show', [
                            'image' => $image,
                            'preset' => $preset ?? 'medium',
                            'q' => ($lazy ? '5' : ($quality ?? config('image.quality')))
                         ]) !!}"
                         data-src="{!! route('frontend.image.show', [
                            'image' => $image,
                            'preset' => $preset ?? 'medium',
                            'q' => ($quality ?? config('image.quality'))
                         ]) !!}"
                         alt="{{ $image->title }}"
                         loading="{{ $lazy ? 'lazy' : 'null' }}"
                    />
                </div>
            @endif
        </div>
    @endforeach
</div>
