# Changelog

All notable changes to `bongo/gallery` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.3] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` (363 lines) - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` (322 lines) - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` (870 lines) - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` (460 lines) - GitHub Copilot code templates and patterns
- **Enhanced README.md**: Expanded with comprehensive installation, usage, and integration sections (457 new lines)

## [3.0.0] - 2024-10-07

### Major Release - v3.0

This major version represents a complete architectural overhaul with modernized code, improved API design, and better framework integration.

### Architecture Changes

#### Service Provider Modernization
- **Extended AbstractServiceProvider**: Migrated from manual registration to framework conventions
  - Automatic registration of config, routes, views, migrations, translations
  - Simplified service provider code (24 line update)
  - Better consistency with bongo/framework patterns
  - Removed redundant boilerplate code

#### Model Simplification
- **Removed GalleryItem Model**: Simplified to use polymorphic image relationships directly
  - Deleted `src/Models/GalleryItem.php` (28 deletions)
  - Deleted migration `create_gallery_items_table.php` (63 deletions)
  - Uses `HasImages` trait from bongo/image package
  - Images stored in polymorphic `imageables` pivot table
  - Simplified model with `MorphToMany` relationship (42 line update)

#### Event System Updates
- **GalleryCreated Event Removed**: Simplified event architecture
  - Deleted `src/Events/GalleryCreated.php` (37 deletions)
  - Focused on `GalleryUpdated` and `GalleryDeleted` events
  - Updated event class structure (21 lines each)
  - Better alignment with framework event patterns

### API Improvements

#### New API Controller
- **Added GalleryController API**: Complete RESTful image management
  - New `src/Http/Controllers/Api/GalleryController.php` (144 lines)
  - `index()` - Get all images for a gallery
  - `store()` - Upload new image to gallery
  - `update()` - Update image properties (title, alt, sort order)
  - `destroy()` - Delete image from gallery
  - Full integration with bongo/image package
  - JSON responses for all endpoints

#### API Routes
- **New API Routes**: Added `src/Routes/api.php` (26 lines)
  - `GET /api/galleries/{id}` - Get gallery images
  - `ANY /api/galleries/{id}/store` - Upload image
  - `POST /api/galleries/{id}/update` - Update image
  - `POST /api/galleries/{id}/delete` - Delete image
  - Protected by `auth:sanctum` middleware
  - Named routes with `api.gallery.*` prefix

### Backend Controller Updates

#### Simplified Backend Controller
- **Streamlined GalleryController**: Reduced from 200+ to ~100 lines
  - Removed image upload handling (moved to API controller)
  - Focused on gallery CRUD operations only
  - Cleaner separation of concerns
  - Better code maintainability
  - Updated to use framework base controller methods

#### DataTable Controller Updates
- **Updated GalleryDatatableController**: Modernized DataTable integration (20 line update)
  - Better query optimization
  - Improved sorting and filtering
  - Framework-compliant response format

### Frontend Improvements

#### Frontend Controller Modernization
- **Updated Frontend Controller**: Improved preview functionality (30 line update)
  - Better UUID-based gallery lookup
  - Improved view composition
  - Enhanced error handling
  - Developer-only preview access

#### View Updates
- **Enhanced Gallery Template**: Modernized `frontend/partials/gallery.blade.php` (49 insertions)
  - Better image rendering
  - Improved responsive design
  - Enhanced lightbox integration
  - Lazy loading support
- **Updated Item Template**: Simplified `frontend/partials/item.blade.php` (3 deletions)
  - Removed redundant code
  - Cleaner markup

### Request Validation

#### Removed StoreGalleryRequest
- **Deleted StoreGalleryRequest**: Simplified validation (30 deletions)
  - Validation moved to controller or UpdateGalleryRequest
  - Reduced code duplication

#### Updated UpdateGalleryRequest
- **Enhanced UpdateGalleryRequest**: Modernized validation rules (14 line update)
  - Better validation messages
  - Framework-compliant validation
  - Support for new fields

### Backend Views

#### Form Enhancements
- **Updated Form Details Partial**: Enhanced `backend/partials/form/details.blade.php` (26 line update)
  - Better field organization
  - Improved UX
  - Enhanced validation display

#### Show View Updates
- **Enhanced Gallery Show View**: Updated `backend/show.blade.php` (58 insertions)
  - Image gallery display
  - Drag-and-drop reordering support
  - Image management interface
  - Delete image functionality
  - Edit image properties inline

#### Create/Edit Views
- **Minor Updates**: Updated `backend/create.blade.php` and `backend/edit.blade.php` (2 lines each)
  - Consistency improvements
  - Better form integration

### Routes Restructuring

#### Backend Routes
- **Modernized Backend Routes**: Updated `src/Routes/backend.php` (74 line update)
  - Better route naming consistency
  - Improved middleware application
  - Cleaner route definitions
  - DataTable route integration

#### Frontend Routes
- **Updated Frontend Routes**: Enhanced `src/Routes/frontend.php` (38 line update)
  - Preview route with developer middleware
  - Better route naming
  - UUID-based gallery access

### Translation Updates

#### Backend Translations
- **Enhanced Translations**: Updated `src/Translations/en/backend.php` (26 line update)
  - New translation keys for API responses
  - Updated success/error messages
  - Better internationalization support

### Testing

#### Test Suite Modernization
- **Updated TestCase**: Enhanced `tests/TestCase.php` (28 line update)
  - Orchestra Testbench integration
  - Laravel 10 compatibility
  - Better test helper methods

### Configuration

#### Updated Configuration Files
- **EditorConfig**: Updated `.editorconfig` (438 insertions)
  - Consistent code formatting
  - Better IDE integration
  - Laravel conventions
- **StyleCI**: Updated `.styleci.yml` (14 line update)
  - Laravel 10 preset
  - Modern PHP code style

### Database

#### Migration Updates
- **Gallery Table Migration**: Updated `create_galleries_table.php` (21 line update)
  - Added UUID field
  - Added status field (pending/active/inactive)
  - Better indexing
  - Audit fields (created_by, updated_by, deleted_by)

### Seeders

#### New Package Seeder
- **Added PackageSeeder**: New `src/Seeders/PackageSeeder.php` (24 lines)
  - Seed sample galleries
  - Test data generation
  - Development environment support

### Statistics
- **32 files changed** with 883 insertions and 599 deletions
- Net reduction of 284 lines while adding significant functionality
- Complete API layer added (144 new lines)
- Simplified model architecture
- Better framework integration

## [2.0.7] - 2024-02-07

### Added
- **DT-366**: Gallery Builder - Image Updates
  - Enhanced image management functionality
  - Improved image upload and processing
  - Better image optimization

### Changed
- **Laravel 10 & PHP 8.2 Upgrade**: Complete framework upgrade
  - Updated `composer.json` for Laravel 10 compatibility
  - Updated codebase for PHP 8.2 compatibility
  - Modernized type declarations and nullable types
  - Updated Pint and StyleCI configurations

### Improved
- **DT-265**: Renaming Images
  - Added ability to rename image files
  - Automatic content replacement in related tables (pages, posts, projects, categories)
  - File system updates with content sync

- **DT-265**: Original File Names
  - Preserve original file names during upload
  - Better file name handling and sanitization
  - Improved file organization

### Fixed
- **Image URL Escaping**: Un-escaped image URLs to allow lazy loading
  - Fixed lazy loading compatibility
  - Better image loading performance
  - Improved user experience

- **Editor Lightbox**: Quick fix to prevent editor from loading lightbox
  - Fixed conflict with editor interface
  - Better separation of concerns

### Features
- **DT-211**: Gallery Module
  - Complete gallery module implementation
  - CRUD operations for galleries
  - Image upload and management
  - Drag-and-drop image reordering
  - Image alt tag editing
  - Multiple image assignment to galleries

### Initial Development
- **Gallery Builder**: Created new gallery builder from scratch
  - Backend admin interface
  - Frontend display templates
  - Image relationships
  - Status management (pending/active/inactive)
  - Soft delete support
  - UUID-based public URLs
  - Key-based programmatic access

---

**Package**: `bongo/gallery`
**Description**: Add the ability to create custom galleries from within the admin.
**Repository**: https://bitbucket.org/designtec/gallery
**Private Composer Repository**: https://designtecpackages.co.uk
