<?php

namespace Bongo\Gallery\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Gallery\Events\GalleryDeleted;
use Bongo\Gallery\Events\GalleryUpdated;
use Bongo\Gallery\Http\Requests\UpdateGalleryRequest;
use Bongo\Gallery\Models\Gallery;
use Exception;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class GalleryController extends AbstractController
{
    public function index(): View
    {
        return view('gallery::backend.index');
    }

    public function create(): RedirectResponse
    {
        $gallery = Gallery::create();

        return redirect()
            ->route('backend.gallery.edit', $gallery->id)
            ->success(trans('gallery::backend.store_success'));
    }

    public function show(Gallery $gallery): View
    {
        return view('gallery::backend.show', compact('gallery'));
    }

    public function edit(Gallery $gallery): View
    {
        return view('gallery::backend.edit', compact('gallery'));
    }

    /**
     * @throws Exception
     */
    public function update(UpdateGalleryRequest $request, Gallery $gallery): RedirectResponse
    {
        $gallery->update($request->all());
        event(new GalleryUpdated($gallery));

        return redirect()
            ->route('backend.gallery.show', $gallery->id)
            ->success(trans('gallery::backend.update_success'));
    }

    /**
     * @throws Exception
     */
    public function destroy(Gallery $gallery)
    {
        if ($gallery->delete()) {
            event(new GalleryDeleted($gallery));
            $redirect = back();

            // If the gallery was deleted from their detail view,
            // we'll redirect back to the gallery list view.
            if (route('backend.gallery.show', $gallery) == $redirect->getTargetUrl()) {
                $redirect = redirect()->route('backend.gallery.index');
            }

            return $redirect->success(trans('gallery::backend.delete_success'));
        }

        return back()->error(trans('gallery::backend.delete_failed'));
    }
}
