<?php

namespace Bongo\Gallery\Http\Controllers\Frontend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Gallery\Models\Gallery;
use Illuminate\View\View;

class GalleryController extends AbstractController
{
    public function preview(string $uuid): View
    {
        $gallery = Gallery::where('uuid', '=', $uuid)->first();
        if (! $gallery || (! auth()->user() || ! auth()->user()->isDeveloper())) {
            abort('404', 'Gallery could not be found');
        }

        $gallery->loadMissing('images');

        return view('gallery::frontend.preview')->with([
            'gallery' => $gallery,
            'columns' => '4',
            'padding' => 'medium',
            'lazy' => true,
            'lightbox' => true,
        ]);
    }
}
