<?php

use Bongo\Gallery\Models\Gallery;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGalleriesTable extends Migration
{
    public function up()
    {
        Schema::create('galleries', function (Blueprint $table) {

            // Primary
            $table->increments('id');
            $table->uuid('uuid')->index();

            // Fields
            $table->string('name')->nullable();
            $table->string('key')->nullable()->index();
            $table->enum('status', [Gallery::PENDING, Gallery::ACTIVE, Gallery::INACTIVE])->default(Gallery::PENDING);

            // Audit
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('updated_by')->nullable()->index();
            $table->unsignedInteger('deleted_by')->nullable()->index();

            // Timestamps
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down()
    {
        Schema::dropIfExists('galleries');
    }
}
