<?php

namespace Bongo\Gallery\Models;

use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasKey;
use Bongo\Framework\Traits\HasStatus;
use Bongo\Framework\Traits\HasUUID;
use Bongo\Image\Interfaces\Imageable;
use Bongo\Image\Traits\HasImages;
use Illuminate\Database\Eloquent\SoftDeletes;

class Gallery extends AbstractModel implements Imageable
{
    public const PENDING = 'pending';
    public const ACTIVE = 'active';
    public const INACTIVE = 'inactive';

    use SoftDeletes;
    use HasKey;
    use HasImages;
    use HasStatus;
    use HasUUID;

    /** @var array */
    protected $fillable = [
        'name',
        'status',
    ];
}
