<?php

use Bongo\Gallery\Http\Controllers\Api\GalleryController;
use Illuminate\Support\Facades\Route;

Route::as('gallery.')
    ->prefix(config('gallery.prefix'))
    ->group(function () {

        // Gallery/{id}/
        Route::prefix('{id}')
            ->group(function () {

                Route::get('/', [GalleryController::class, 'index'])
                    ->name('index');

                Route::any('store', [GalleryController::class, 'store'])
                    ->name('store');

                Route::post('update', [GalleryController::class, 'update'])
                    ->name('update');

                Route::post('delete', [GalleryController::class, 'destroy'])
                    ->name('destroy');
            });
    });
