<?php

use Bongo\Gallery\Http\Controllers\Backend\GalleryController;
use Bongo\Gallery\Http\Controllers\Backend\GalleryDatatableController;
use Illuminate\Support\Facades\Route;

Route::as('gallery.')
    ->prefix(config('gallery.prefix'))
    ->group(function () {

        Route::get('/', [GalleryController::class, 'index'])
            ->name('index');

        Route::get('create', [GalleryController::class, 'create'])
            ->name('create');

        Route::get('datatable', [GalleryDatatableController::class, 'index'])
            ->name('datatable');

        // Gallery/{gallery}/
        Route::prefix('{gallery}')
            ->group(function () {

                Route::get('/', [GalleryController::class, 'show'])
                    ->name('show');

                Route::get('edit', [GalleryController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [GalleryController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [GalleryController::class, 'destroy'])
                    ->name('destroy');
            });
    });
