@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $gallery->name }}
        @slot('actions')
            @linkButton(['name' => 'Preview','url' => route('frontend.gallery.preview', $gallery->uuid), 'target' => '_blank'])
            @deleteButton(['name' => trans('gallery::backend.delete'), 'url' => route('backend.gallery.destroy', $gallery->id)])
            @backButton(['name' => trans('gallery::backend.index'), 'url' => route('backend.gallery.index')])
            @editButton(['name' => trans('gallery::backend.edit'), 'url' => route('backend.gallery.edit', $gallery->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6 mb-4">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4'])
                    @static(['name' => 'Name', 'value' => $gallery->name])
                @endcomponent
            </div>
            <div class="md:col-span-1">
                @component('blade::card')
                    @static(['name' => 'Status', 'value' => $gallery->status])
                @endcomponent
            </div>
        </section>

        <section>
            @if ($gallery->hasImages())
                @foreach($gallery->images as $image)
                    <div class="mb-2 bg-white overflow-hidden shadow">
                        <div class="px-4 py-3">

                            <div class="flex md:flex-initial items-center md:grid md:gap-2 md:grid-cols-3">

                                <div class="flex flex-1 md:col-span-1">
                                    <span
                                        class="inline-flex self-center mr-4 px-3 py-0.5 rounded-full text-sm font-medium leading-5 bg-gray-100 text-gray-800 group-hover:bg-gray-200"
                                    >
                                        {{ $image->pivot->sort_order }}
                                    </span>
                                    <span class="inline-flex self-center md:flex-initial">
                                        <img class="inline-block h-12 w-16"
                                             src="{{ route('frontend.image.show', ['image' => $image, 'preset' => 'thumb']) }}"
                                             alt="{{ $image->title }}"
                                        />
                                    </span>
                                </div>

                                <div class="hidden md:block md:col-span-1 text-xs">
                                    <div>
                                        <span class="text-gray-400">Alt Tag:</span>
                                        {{ $image->title }}
                                    </div>
                                    <div>
                                        <span class="text-gray-400">File:</span>
                                        {{ $image->name }}
                                    </div>
                                    <div>
                                        <span class="text-gray-400">Size:</span>
                                        W{{ $image->width }} X H{{ $image->height }}
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                @endforeach
            @else
                @component('blade::card')
                    <div class="message text-center">
                        <div class="message-text font-semibold">
                            No Images Found
                        </div>
                    </div>
                @endcomponent
            @endif
        </section>
    @endcomponent
@stop
