<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateImagesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('images')) {
            Schema::create('images', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid('uuid')->index();

                // Fields
                $table->string('name')->nullable();
                $table->string('title')->nullable();
                $table->string('width')->nullable();
                $table->string('height')->nullable();
                $table->string('path');
                $table->string('ext')->nullable();
                $table->string('size')->nullable();
                $table->string('type')->nullable(); // e.g. wysiwyg, dropzone
                $table->integer('sort_order')->nullable();

                // Audit
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();
                $table->unsignedInteger('deleted_by')->nullable()->index();

                // Timestamps
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('images');
    }
}
